module ssymbol(){
	mult = 5;
	height = 1*mult;
	$fs = 0.1;

	// Draw the arc on the top of the symbol
	translate([mult*2.5, mult*4.5, height*0.5]){
		difference(){
			cylinder(center = true, height, mult*3, mult*3);
			cylinder(center = true, height*2, mult*2, mult*2);
			translate([0, -mult*3, -height*0.5]){
				cube(mult*6, mult*3,height, center=true);
			}
		}
	}

	// Draw the arc on the bottom of the symbol
	translate([-mult*2.5, -mult*4.5, height*0.5]){
		difference(){
			cylinder(center = true, height, mult*3, mult*3);
			cylinder(center = true, height*2, mult*2, mult*2);
			translate([0, mult*3, height*0.5]){
				cube(mult*6, mult*3,height, center=true);
			}
		}
	}

	// Draw the little line coming off the top arc
	translate([mult*5, mult*3.5, height*0.5]){
		cube([mult*1, mult*2, height], center = true);
	}

	// Draw the little line coming off the bottom arc
	translate([-mult*5, -mult*3.5, height*0.5]){
		cube([mult*1, mult*2, height], center = true);
	}


	// Draw the big line running down the middle
	translate([0,0, height*0.5]){
		cube([mult*1, mult*15, height], center = true);
	}

	// Draw the little line crossing the big one
	translate([0,0, height*0.5]){
		cube([mult*5, mult*1, height], center = true);
	}

	// Round the ends of the lines

	// Top arc line rounding
	translate([mult*5, mult*2.5, height*0.5]){
		cylinder(center = true, height, 0.5*mult, 0.5*mult);
	}

	// Bottom arc line rounding
	translate([-mult*5, -mult*2.5, height*0.5]){
		cylinder(center = true, height, 0.5*mult, 0.5*mult);
	}

	// Main line top rounding
	translate([0, mult*7.5, height*0.5]){
		cylinder(center = true, height, 0.5*mult, 0.5*mult);
	}

	// Main line bottom rounding
	translate([0, -mult*7.5, height*0.5]){
		cylinder(center = true, height, 0.5*mult, 0.5*mult);
	}

	// Crossing line left rounding
	translate([mult*2.5, 0, height*0.5]){
		cylinder(center = true, height, 0.5*mult, 0.5*mult);
	}

	// Crossing line right rounding
	translate([-mult*2.5, 0, height*0.5]){
		cylinder(center = true, height, 0.5*mult, 0.5*mult);
	}
}